<?php

namespace Mautic\ApiBundle;

/**
 * Class ApiEvents.
 */
final class ApiEvents
{
    /**
     * The mautic.client_pre_save event is thrown right before an API client is persisted.
     *
     * The event listener receives a Mautic\ApiBundle\Event\ClientEvent instance.
     *
     * @var string
     */
    const CLIENT_PRE_SAVE = 'mautic.client_pre_save';

    /**
     * The mautic.client_post_save event is thrown right after an API client is persisted.
     *
     * The event listener receives a Mautic\ApiBundle\Event\ClientEvent instance.
     *
     * @var string
     */
    const CLIENT_POST_SAVE = 'mautic.client_post_save';

    /**
     * The mautic.client_post_delete event is thrown after an API client is deleted.
     *
     * The event listener receives a Mautic\ApiBundle\Event\ClientEvent instance.
     *
     * @var string
     */
    const CLIENT_POST_DELETE = 'mautic.client_post_delete';

    /**
     * The mautic.build_api_route event is thrown to build Mautic API routes.
     *
     * The event listener receives a Mautic\CoreBundle\Event\RouteEvent instance.
     *
     * @var string
     */
    const BUILD_ROUTE = 'mautic.build_api_route';

    /**
     * The mautic.api_on_entity_pre_save event is thrown after an entity about to be saved via API.
     *
     * The event listener receives a Mautic\ApiBundle\Event\ApiEntityEvent instance.
     *
     * @var string
     */
    const API_ON_ENTITY_PRE_SAVE = 'mautic.api_on_entity_pre_save';

    /**
     * The mautic.api_on_entity_post_save event is thrown after an entity is saved via API.
     *
     * The event listener receives a Mautic\ApiBundle\Event\ApiEntityEvent instance.
     *
     * @var string
     */
    const API_ON_ENTITY_POST_SAVE = 'mautic.api_on_entity_post_save';
}
